#ifndef usb_R8_2H
#define usb_R8_2H
#include <cstring>
using namespace std;

#define bufferLength 32
#define searchMaxDevice 10
//--------------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete [] x;
  x = NULL;
}
//--------------------------------------------------------------
void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);
//--------------------------------------------------------------
class TUSBDevice {
   private:
     static TUSBDevice *instance;
     TUSBDevice();
     string pathUSBDevice;
     DWORD memberIndex;
     PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData;
     DWORD numberOfBytesRead;
     DWORD result;
     GUID classGuid;
     HMODULE hHidLib;
     DWORD deviceInterfaceDetailDataSize;
     HDEVINFO deviceInfoSet;
     SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
     USHORT usVid;
     const char *chVid;
   public:
     static TUSBDevice *getInstance();
     ~TUSBDevice();
     void setCharVid(const char *vid);
     void displayError(const char* msg);
     bool asynchReadUSBReport(HANDLE hidDevObject, void *inputReportBuffer,
                              ULONG inputReportBufferLength);
     HANDLE asynchOpenUSBDevice();
     string getUSBDevicePath(UINT);
};
//--------------------------------------------------------------
#endif
//--------------------------------------------------------------

